'******************************************** Copyright Bensonium 2023 ********************************************************
'
'Written by: Roderick Benson
'Releaase Date: 11/09/2023
'This program is supplied as is with no express warranties. The user accepts full responsibility for their use of it and neither Bensonium.com nor Roderick Benson will be liable for any issues that arise from using this program. 
'
'*******************************************************************************************************************************

option Explicit
on error resume next

'Dimension variables
dim Month(12), HeadingHTML, TailHTML, BestDate, FYear, FMonth, UserChoice, isDefault, RT, OrigFN, SourceFolder, TargetFolder, FileToRootDirectory
dim MyVideoPath, MyImagesPath, MyComputerPath, FileType, FolderName, TextFile, F, InputRequired, ScanSubDirectories, OrigPath
dim objConnection, objRecordSet, ObjExplorer, ObjFolder, oShell, oShell2, oFS, JobSummary


'Define objects
Set oShell=CreateObject("Shell.Application")
set oShell2=CreateObject("WScript.Shell")
Set oFS=CreateObject("Scripting.FileSystemObject")
Set objConnection = CreateObject("ADODB.Connection")
Set objRecordSet = CreateObject("ADODB.Recordset")
objConnection.Open "Provider=Search.CollatorDSO;Extended Properties='Application=Windows';"

'Set Variable Values
Const MY_VIDEOS = &He&
const MY_IMAGES = &H27&
Const ForReading = 1, ForWriting = 2, ForAppending = 8
Const TristateUseDefault = -2, TristateTrue = -1, TristateFalse = 0
InputRequired=true
MyVideoPath=oShell.Namespace(MY_VIDEOS).self.path
MyImagesPath=oShell.Namespace(MY_IMAGES).self.path
MyComputerPath=oShell2.specialfolders("MyComputer")
Month(1)="January": Month(2)="February" : Month(3)="March" : Month(4)="April" : Month(5)="May": Month(6)="June"
Month(7)="July": Month(8)="August" : Month(9)="September" : Month(10)="October" : Month(11)="November" : Month(12)="December"



Do While InputRequired=true
	InputRequired=false
	'User Input
	UserChoice=inputbox("This program sorts photos or videos into yearly folders and then monthly subfolders based on the date they were captured. Please select one of the options below" & string(3, vbCrlf) _
	& "Put photos into Year\Month subfolders" & chr(9) & "[1]"  & string(2,vbcrlf) _
	& "Put vidoes into Year\Month subfolders" & chr(9) & "[2]" & string(2,vbcrlf) _
	& "Move images from selected folder to" & chr(9) & "[3]" & vbCrlf & " the system image folder." & string(2,vbCrlf) _
	& "Move videos from selected folder to" & chr(9) & "[4]" & vbCrlf & " the system video folder." & string(2,vbCrlf),"Image Video File Management Program",1)	 
	if UserChoice="" then WScript.Quit
	if not (UserChoice=1 or UserChoice=2 or UserChoice=3 or UserChoice=4) then
		InputRequired=true
		msgbox "Please choose a number between 1 and 4 based on the options above.",vbCritical
	end if
	err.clear
loop	


if UserChoice=1 then
	FileType="Image"
	FolderName=" Photos"
	isDefault=msgbox("Do you want work inside the default system picture folder?",vbYesNo,"Work inside Default Folder")
	JobSummary="Move images"
elseif UserChoice=2 then
	FileType="Video"
	FolderName=" Videos"
	isDefault=msgbox("Do you want work inside the default system video folder?",vbYesNo,"Work inside Default Folder")
	JobSummary="Move Videos"
elseif UserChoice=3 then
	JobSummary="Move Images"
	FolderName=" Photos"
elseif UserChoice=4 then
	JobSummary="Move Videos"
	FolderName=" Videos"
end if


if UserChoice>2 or isDefault=vbNo then
	Set objFolder = oShell.BrowseForFolder(0, "Select Folder", 0, MyComputerPath)
	SourceFolder=objFolder.self.path
	if UserChoice<3 then
		HeadingHTML="<b>Sorting " & FileType & " files into their respective year, month folders ..</b><br/><br/>Working on Files..<br/><ul>"
		if msgbox("Create the subfolders inside the folder you are currently working?" & string(3,vbcrlf) & "If you select No, then the photos/videos will be moved into folders located directly inside your default pictures/videos folder.",vbyesno,"Work exclusively inside the source folder you chose to work on?")=vbno then
			TargetFolder=iif(UserChoice=1,MyImagesPath,MyVideoPath)
		else
			TargetFolder=objFolder.self.path
		end if
	else
		ScanSubDirectories=msgbox("Do you want to move " & FileType & " files in all the subfolders of your selected directory: " & SourceFolder & "?",vbYesNo,"Scan Subfolders")
		if UserChoice=3 then
			HeadingHTML=iif(ScanSubDirectories=vbyes,"<p><b>Moving Images from your chosen folder and its subfolders to the System Image folder</b></p><ul>","<p><b>Moving Images from your chosen folder to the System Image folder</b></p><ul>") 	
		elseif UserChoice=4 then
			HeadingHTML=iif(ScanSubDirectories=vbyes,"<p><b>Moving Videos from your chosen folder and its subfolders to the System Video folder</b></p><ul>","<p><b>Moving Videos from your chosen folder to the System Video folder</b></p><ul>") 	
		end if
	end if
	if UserChoice>2 then
		JobSummary=JobSummary & " from " & SourceFolder & iif(ScanSubDirectories=vbyes," and its sub-folders","") & " back into the system folder that holds your" & FolderName & ". Note the" & FolderName & " shall not be placed into year and month subfolders but will all be located in the" & iif(FolderName=" Photos"," Pictures"," Videos") & " folder using this option."
	elseif TargetFolder=MyImagesPath or TargetFolder=MyVideoPath then
		JobSummary=JobSummary & " from " & chr(34) & SourceFolder & chr(34) & " to your" & iif(FolderName=" Photos"," Pictures"," Videos") & " folder sorting them into Year and month subfolders based on when they were acquired. These subfolders shall be located inside your system" & iif(FolderName=" Photos"," Pictures"," Videos") & " folder."
	else
		JobSummary=JobSummary & " into year\month sub-folders based on when the images were acquired. These subfolders shall be located inside the working folder you have selected which is " & chr(34) & SourceFolder & chr(34) & "." 
	end if
else
	SourceFolder=iif(UserChoice=1,MyImagesPath,MyVideoPath)
	TargetFolder=SourceFolder
	JobSummary=JobSummary & " from your system" & iif(FolderName=" Photos"," Pictures"," Videos") & " folder into Year\Month sub-folders based on when your" & FolderName & " were acquired. These subfolders shall be located inside your system" & iif(FolderName=" Photos"," Pictures"," Videos") & " folder."
end if

 


'Last Chance to quit program
if msgbox("You have selected to do the following:" & string(2,vbCrlf) & JobSummary & string(3,vbCrlf) & "Please confirm you want to continue by pushing the Yes button below." ,vbYesNo,"Job Summary")=vbno then WScript.Quit
'///////

set objFolder=ofs.Getfolder(SourceFolder)

if ofs.FileExists(objFolder & "\File Sort Report.txt") then
	set TextFile =ofs.CreateTextFile(objFolder & "\File Sort Report.txt")
else
	set TextFile = ofs.OpenTextFile(objFolder & "\File Sort Report.txt", ForAppending, True, TristateFalse)
end if
CreateExplorerWindow

if UserChoice<3 then
	TextFile.writeline "Sorting " & FileType & " Files into year and month subfolders based where possible on their date taken date or their date created if it falls before the date the file was last modified." & string(2,vbCrlf)
	for each F in objFolder.Files
		if ProcessFile(f.name,UserChoice) then
			OrigFN=F.name
			BestDate=ReturnBestDate(F)
			FYear=ReturnYear(BestDate)
			FMonth=ReturnMonth(BestDate)
			if not ofs.FolderExists(TargetFolder & "\" & FYear & FolderName) then ofs.CreateFolder(TargetFolder & "\" & FYear & FolderName)
			if not ofs.FolderExists(TargetFolder & "\" & FYear & FolderName & "\" & FMonth) then ofs.CreateFolder(TargetFolder & "\" & FYear & FolderName & "\" & FMonth)
			Err.Clear
			F.move TargetFolder & "\" & FYear & FolderName & "\" & FMonth & "\" & UniqueName(F.name,TargetFolder & "\" & FYear & FolderName & "\" & FMonth)
			if Err.Number>0 Then
				RT=RT & "Permission denied error encounted so " & F.name & " file could not be moved." & vbCrlf
				TailHTML="<li>Permission denied error encounted so " & F.name & " file could not be moved.</li>" & TailHTML
			else
				TailHTML="<li>" & OrigFN & " moved to subfolder " & TargetFolder & "\" & FYear & FolderName & "\" & FMonth & "</li>" & TailHTML
				RT=RT & OrigFN & " moved to subfolder " & TargetFolder & "\" & FYear & FolderName & "\" & FMonth & vbCrlf
			end if
			objExplorer.Document.Body.InnerHTML = HeadingHTML & TailHTML	
		end if
	next
elseif UserChoice=3 then 'Move Images into default Image Folder
	TextFile.writeline "Moving image files into the Pictures system folder." & string(2,vbCrlf)
	MoveImages ObjFolder
elseif UserChoice=4 then 'Move Videos into default Video Folder
	TextFile.writeline "Moving video files into the Videos system folder." & string(2,vbCrlf)
	MoveVideos ObjFolder
end if	

TextFile.writeline RT
TextFile.close
TailHTML=TailHTML & "</ol>"
objExplorer.Document.Body.InnerHTML = "<b>Program Completed Successfully.</b><br/><br/><i>You can now close this window if you like.</i><br/><br/><ol>" & TailHTML
set oShell=Nothing
set oShell2=Nothing
set oFS=Nothing
Set objConnection = Nothing
Set objRecordSet = Nothing
Set objFolder = Nothing
set ObjExplorer = Nothing
set TextFile = Nothing


Sub MoveVideos(pFld)
	dim Fld
	'on error resume next
	if pFld.Path<>MyVideoPath then 'Only execute if source and target different paths.
		objExplorer.Document.Body.InnerHTML = HeadingHTML & "<p>Working on Folder: " & pFld.name & "</p>" & TailHTML
		for each F in pFld.Files
			if ucase(right(F.name,3))="MP4" or ucase(right(F.name,3))="MOV" or ucase(right(F.name,3))="AVI" or ucase(right(F.name,3))="WMV" Then
				OrigFN=F.name
				OrigPath=replace(F.Path,OrigFN,"")
				F.move MyVideoPath & "\" & UniqueName(F.name, MyVideoPath)
				if Err.Number>0 Then
					RT=RT & "Permission denied error encounted so " & F.name & " file could not be moved." & vbCrlf
					TailHTML="<li>Permission denied error encounted so " & F.name & " file could not be moved.</li>" & TailHTML
				else
					RT=RT & OrigFN & " moved from " & OrigPath & " to " & F.Path & vbCrlf
					TailHTML="<li>Moving " & OrigFN & " from " & OrigPath & " to " & F.path & "</li>" & TailHTML
				end if
				Err.Clear
				objExplorer.Document.Body.InnerHTML = HeadingHTML & TailHTML
			end if
		next
	end if
	if ScanSubDirectories=vbYes then
		for each Fld in pFld.subfolders
			MoveVideos(Fld)
		next
	end if
end sub

Sub MoveImages(pFld)
	dim Fld
	on error resume next
	if pFld.Path<>MyImagesPath then 'Only execute if source and target are different paths.
		objExplorer.Document.Body.InnerHTML = HeadingHTML & "<p>Working on Folder: " & pFld.name & "</p>" & TailHTML
		for each F in pFld.Files
			if ucase(right(F.name,3))="JPG" or ucase(right(F.name,4))="JPEG" or ucase(right(F.name,3))="TIF" or ucase(right(F.name,4))="TIFF" or ucase(right(F.name,3))="BMP" or ucase(right(F.name,3))="PNG" or ucase(right(F.name,4))="HEIC"  Then
				OrigFN=F.name
				OrigPath=replace(F.Path,OrigFN,"")
				F.move MyImagesPath & "\" & UniqueName(F.name,MyImagesPath)
				if err.number>0 then
					RT=RT & "Permission denied error encounted so " & F.name & " file could not be moved." & vbCrlf
					TailHTML="<li>Permission denied error encounted so " & F.name & " file could not be moved.</li>" & TailHTML
				else
					RT=RT & OrigFN & " moved from " & OrigPath & " to " & F.Path & vbCrlf
					TailHTML="<li>Moving " & OrigFN & " from " & OrigPath & " to " & F.path & "</li>" & TailHTML
				end if
				Err.Clear
				objExplorer.Document.Body.InnerHTML = HeadingHTML & TailHTML
			end if
		next
	end if
	if ScanSubDirectories=vbYes then
		for each Fld in pFld.subfolders
			MoveImages(Fld)
		next
	end if
end sub

Function UniqueName(pName,pPath)
	dim Ext,P1,P2,Num
	do while oFS.FileExists(pPath & "\" & pName)
		P1=instrrev(pName,"(")
		P2=instrrev(pName,")")
		if P1>0 and P2>0 and P1<P2 then
			Num=mid(pName,P1+1,P2-P1-1)
			if isNumeric(Num) then
				pName=left(pName,P1) & CStr(CInt(Num)+1) & mid(pName,P2)
			else
				Ext=instr(pName,".")
				if Ext>0 then pName=left(pName,Ext-1) & "(2)" & mid(pName,Ext) else	pName=pName & "(2)"
			end if
		Else
			Ext=instr(pName,".")
			if Ext>0 then pName=left(pName,Ext-1) & "(2)" & mid(pName,Ext) else	pName=pName & "(2)"
		end if
	loop
	UniqueName=pName
end Function
	
	
Function ReturnBestDate(pFile)
	on error resume next
	ReturnBestDate=iif(pFile.DateCreated<pFile.DateLastModified,pFile.DateCreated,pFile.DateLastModified)
	objRecordSet.Open "SELECT System.FileName, System.Photo.DateTaken FROM SYSTEMINDEX Where System.ItemFolderPathDisplay ='" & pFile.path  & "' AND System.FileName = '" & pFile.name & "'", objConnection
	if err.number=0 then
		objRecordSet.MoveFirst
		if objRecordSet.Fields("System.Photo.DateTaken")<>"" then ReturnBestDate=objRecordSet.Fields("System.Photo.DateTaken")
		objRecordSet.Close
		return
	Else
		Err.Clear
	end if
end Function

Function ReturnYear(pDate)
	ReturnYear=mid(pDate, InstrRev(pDate,"/")+1,4)
End Function

Function ReturnMonth(pDate)
	ReturnMonth=Month(mid(pDate,Instr(pDate,"/")+1,2))
End Function		
	
Sub CreateExplorerWindow()
	Set objExplorer = CreateObject("InternetExplorer.Application")
    objExplorer.Navigate "about:blank"   
    objExplorer.ToolBar = 0
    objExplorer.StatusBar = 1
    objExplorer.Width = 1000
    objExplorer.Height = 800 
    objExplorer.Visible = 1             
    objExplorer.Document.Title = iif(UserChoice<2,"Sorting video or image files into their respective years... ","Gathering" & FolderName & " from your selected folder and moving them to the system " & iif(FolderName=" Photos"," Pictures"," Videos") & " Folder... ") & "Please do not close this window until program has completed."
    objExplorer.Document.Body.InnerHTML = HeadingHTML
End sub

function iif(pTest,pTrue,pFalse)
	if pTest Then
		iif=pTrue
	Else
		iif=pFalse
	end if
end function

function ProcessFile(pName, pUserChoice)
	if ucase(right(pName,3))="JPG" or ucase(right(pName,4))="JPEG" or ucase(right(pName,3))="TIF" or ucase(right(pName,4))="TIFF" or ucase(right(pName,3))="BMP" or ucase(right(pName,3))="PNG" or ucase(right(pName,4))="HEIC"  Then
		if pUserChoice=1 then ProcessFile=True else ProcessFile=False
	Elseif ucase(right(pName,3))="MP4" or ucase(right(pName,3))="MOV" or ucase(right(pName,3))="AVI" or ucase(right(pName,3))="WMV" then
		if pUserChoice=2 then ProcessFile=True else ProcessFile=False
	else
		ProcessFile=False
	end if
end function	


	

	

