'******************************************** Copyright Bensonium 2023 ********************************************************
'
'Intaller Program for Image Video Management Program
'Written by: Roderick Benson
'Releaase Date: 11/09/2023
'
'*******************************************************************************************************************************

dim SourcePath, oShell, oFS, PicturePath, UserDirectory, ProgFolder, oShortCut, oFile, ObjPP, Shellapp 
SourcePath = left(WScript.ScriptFullName,(Len(WScript.ScriptFullName))-(len(WScript.ScriptName)+1))

If WScript.Arguments.Named.Exists("elevated") = False Then
	'Launch the script again as administrator
	CreateObject("Shell.Application").ShellExecute "wscript.exe", """" & WScript.ScriptFullName & """ /elevated","","runas",1
	WScript.Quit
Else 'Change the working directory from the system32 folder back to the script's folder.
	if msgbox("Do you want to install the Image/Video Management program?",vbYesNo,"Install Program?")=vbno then wscript.quit
	Set oShell = CreateObject("WScript.Shell")
	oShell.CurrentDirectory = SourcePath
End If 

set Shellapp=CreateObject("Shell.Application")
set oFS=CreateObject("Scripting.FileSystemObject")
GF=oShell.SpecialFolders("MyComputer")
UserDirectory=left(oShell.SpecialFolders("MyDocuments"),instr(4,oShell.SpecialFolders("MyDocuments"),"\"))

if not oFS.FolderExists(UserDirectory & "Public") then oFS.CreateFolder(UserDirectory & "Public")
ProgFolder=UserDirectory & "Public\ImageVideoManagement"
Desktop = oShell.SpecialFolders("Desktop")
if not oFS.FolderExists(ProgFolder) then oFS.CreateFolder ProgFolder
oFS.CopyFolder SourcePath, ProgFolder
oFS.DeleteFile ProgFolder & "\Install.vbs"
set oShortcut = oShell.CreateShortcut(Desktop & "\SortPhotosVideos.lnk")
oShortcut.TargetPath = ProgFolder & "\ImageVideoManagement.vbs"
oShortCut.Save
msgbox "Program Installed"

set oFS=nothing
set oShell=nothing
set oShortcut=nothing
set oFile=nothing

